import React from "react";

export const StatCard = ({ title, value, icon, color }) => {
  return (
    <div className="bg-white p-6 rounded-lg shadow-md flex items-center space-x-4 border border-gray-100">
      <div className={`p-3 rounded-full ${color} text-white text-2xl`}>
        {icon}
      </div>
      <div>
        <h3 className="text-gray-500 text-sm font-medium uppercase tracking-wider">
          {title}
        </h3>
        <p className="text-2xl font-bold text-gray-800">{value}</p>
      </div>
    </div>
  );
};
